import express from "express";
import { 
  createService, 
  getServices, 
  getServiceById,
  updateService, 
  deleteService,
  getPublicServices,
  getPublicServiceBySlug
} from "../controllers/serviceController.js";
import { authenticateToken } from "../middleware/authMiddleware.js";
import upload from "../middleware/uploadMiddleware.js";

const router = express.Router();

// Multer fields
const serviceUpload = upload.fields([
  { name: 'featureImage', maxCount: 1 },
  { name: 'benefitIcons', maxCount: 10 }
]);

// Public routes (must be before authenticateToken)
router.get("/public", getPublicServices);
router.get("/public/:slug", getPublicServiceBySlug);

// All service routes require authentication
router.use(authenticateToken);

router.post("/", serviceUpload, createService);
router.get("/", getServices);
router.get("/:id", getServiceById);
router.put("/:id", serviceUpload, updateService);
router.delete("/:id", deleteService);

export default router;
