import express from "express";
import { 
  createProject, 
  getProjects, 
  updateProject, 
  deleteProject,
  getPublicProjects,
  getPublicProjectBySlug
} from "../controllers/projectController.js";
import { authenticateToken } from "../middleware/authMiddleware.js";
import upload from "../middleware/uploadMiddleware.js";

const router = express.Router();

// Define multer fields we expect
const cpUpload = upload.fields([
  { name: 'featureImage', maxCount: 1 },
  { name: 'challengeSolutionImages', maxCount: 5 },
  { name: 'screenshots', maxCount: 10 }
]);

// Public routes (must be before authenticateToken)
router.get("/public", getPublicProjects);
router.get("/public/:slug", getPublicProjectBySlug);

// All project routes require authentication
router.use(authenticateToken);

router.post("/", cpUpload, createProject);
router.get("/", getProjects);
router.put("/:id", cpUpload, updateProject);
router.delete("/:id", deleteProject);

export default router;
