import { db } from "./index.js";
import { users } from "./schema.js";
import bcrypt from "bcryptjs";
import 'dotenv/config';

const seed = async () => {
  try {
    console.log("🌱 Seeding database...");

    const hashedPassword = await bcrypt.hash("12345678", 10);

    await db.insert(users).values({
      name: "admin",
      email: "admin@gmail.com",
      password: hashedPassword,
    });

    console.log("✅ Admin user created successfully!");
    process.exit(0);
  } catch (error) {
    if (error.code === 'ER_DUP_ENTRY') {
      console.log("⚠️ Admin user already exists.");
    } else {
      console.error("❌ Seeding failed:", error);
    }
    process.exit(1);
  }
};

seed();
