import { mysqlTable, serial, varchar, timestamp, int, text, json, mysqlEnum } from "drizzle-orm/mysql-core";

export const users = mysqlTable("users", {
  id: serial("id").primaryKey(),
  name: varchar("name", { length: 255 }).notNull(),
  email: varchar("email", { length: 191 }).notNull().unique(),
  password: varchar("password", { length: 255 }).notNull(),
  createdAt: timestamp("created_at").defaultNow(),
  updatedAt: timestamp("updated_at").defaultNow().onUpdateNow(),
});

export const projects = mysqlTable("projects", {
  id: serial("id").primaryKey(),
  title: varchar("title", { length: 255 }).notNull(),
  slug: varchar("slug", { length: 191 }).unique().notNull(),
  excerpt: text("excerpt"),
  category: varchar("category", { length: 255 }),
  stack: json("stack"),
  stage: varchar("stage", { length: 255 }),
  featureImage: varchar("feature_image", { length: 255 }),
  challenge: text("challenge"),
  solution: text("solution"),
  challengeSolutionImages: json("challenge_solution_images"),
  howItWorks: text("how_it_works"),
  impact: text("impact"),
  description: text("description"),
  type: mysqlEnum("type", ["web", "app"]).default("web"),
  liveLink: varchar("live_link", { length: 255 }),
  appLink: varchar("app_link", { length: 255 }),
  screenshots: json("screenshots"),
  userId: int("user_id").notNull(),
  createdAt: timestamp("created_at").defaultNow(),
  updatedAt: timestamp("updated_at").defaultNow().onUpdateNow(),
});
