import 'dotenv/config';
import mysql from 'mysql2/promise';

const connection = await mysql.createConnection(process.env.DATABASE_URL);

try {
  // Ensure the migrations tracking table exists
  await connection.execute(`
    CREATE TABLE IF NOT EXISTS \`__drizzle_migrations\` (
      \`id\` serial AUTO_INCREMENT NOT NULL,
      \`hash\` text NOT NULL,
      \`created_at\` bigint,
      CONSTRAINT \`__drizzle_migrations_id\` PRIMARY KEY(\`id\`)
    )
  `);

  // Remove any previously inserted fake entry so drizzle-kit migrate will re-run the real SQL
  await connection.execute(
    "DELETE FROM `__drizzle_migrations` WHERE `hash` = '0000_fixed_beast'"
  );
  console.log('✅ Cleared any previous fake migration entry.');
  console.log('👉 Now run: npm run db:migrate');
  console.log('   The migration SQL now uses IF NOT EXISTS, so it is safe even if tables already exist.');
} finally {
  await connection.end();
}
