# Projects API Instruction Guide

We have updated the `projects` table to reflect all the requested fields for a portfolio/project management application. Images are currently processed properly via Multer utilizing `multipart/form-data` requests.

## Full Data Structure
Below is the database structure that outlines what every property should be when modifying it:

| Field Name | Data Type | Notes |
|:---:|:---:|:---|
| `id` | `int (Primary Key)` | Auto-incrementing Project Identifier. |
| `title` | `varchar(255)` | The display title of the project. **Required** |
| `slug` | `varchar(191)` | Unique identifer strictly used for permalinks or lookups. **Required** |
| `excerpt` | `text` | Short description/summary. |
| `category` | `varchar(255)` | Filterable category identifier (e.g. Finance, Education). |
| `stack` | `json` | Array of strings displaying the tech stack (e.g., `["React", "Node"]`). Processed via `JSON.parse`. |
| `stage` | `varchar(255)` | Overall state (e.g. Planning, Completed). |
| `featureImage` | `varchar(255)` | URL path relative string for main banner. Generated via Multer upload (`featureImage` key). |
| `challenge` | `text` | Extended challenge description. |
| `solution` | `text` | Extended solution summary. |
| `challengeSolutionImages`| `json` | Array of URLs for solution screenshots. Generated through Multer array upload (max 5) (`challengeSolutionImages` key). |
| `howItWorks` | `text` | Usage summary text. |
| `impact` | `text` | Performance metrics and final reception logs. |
| `description` | `text` | Heavy descriptive details regarding the project overall. |
| `type` | `enum('web', 'app')`| Sets template variables natively (Default `web`). |
| `liveLink` | `varchar(255)` | Redirection destination for `web` project types. |
| `appLink` | `varchar(255)` | Redirection destination for app store/files for `app` project types. |
| `screenshots` | `json` | Array of URLs for application shots. Generated via Multer array upload (max 10) (`screenshots` key). |
| `userId` | `int` | Automatically generated linking the creator ID with entry. |
| `createdAt` | `timestamp` | Time created. |
| `updatedAt` | `timestamp` | Time of last edit. |

## Available Routes

### Public Endpoints (No Authentication required)
`GET /api/projects/public` - Fetch all projects
`GET /api/projects/public/:slug` - Fetch a single project by its unique slug

### Protected Endpoints (Requires Bearer Token)
`POST /api/projects` - Create a project. Requires **`multipart/form-data`** format.
`GET /api/projects` - Get all projects created by the authenticated user
`PUT /api/projects/:id` - Update an existing project. Requires **`multipart/form-data`** format.
`DELETE /api/projects/:id` - Delete an existing project

## Testing using Postman Collection

We have created a Postman Collection titled `Projects_API.postman_collection.json` located at the root directory of the backend folder. 
However, **for image testing (`POST` and `PUT`)**, you will need to switch the body type in Postman to `form-data`.
1. Open the created endpoint.
2. Under "Body", swap from `raw` to `form-data`.
3. Type the keys like `title`, `slug`, `type` and input text.
4. For files, type `featureImage`, switch the column type from `Text` to `File`, and select an image.
5. Hit Send.

Images are accessible locally going to `http://localhost:5000/uploads/filename.png` after they map successfully.
