# Authentication API

## 1. Register User
Endpoint for creating a new user account.

- **URL:** `/api/auth/register`
- **Method:** `POST`
- **Auth Required:** No

### Request Body
```json
{
  "name": "John Doe",
  "email": "john@example.com",
  "password": "securepassword123"
}
```

### Response
- **Success (201 Created):**
  ```json
  {
    "message": "User registered successfully"
  }
  ```
- **Error (400 Bad Request):**
  ```json
  {
    "message": "User already exists"
  }
  ```

---

## 2. Login User
Endpoint for authenticating a user and receiving a JWT token.

- **URL:** `/api/auth/login`
- **Method:** `POST`
- **Auth Required:** No

### Request Body
```json
{
  "email": "john@example.com",
  "password": "securepassword123"
}
```

### Response
- **Success (200 OK):**
  ```json
  {
    "message": "Login successful",
    "token": "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9...",
    "user": {
      "id": 1,
      "name": "John Doe",
      "email": "john@example.com"
    }
  }
  ```
- **Error (401 Unauthorized):**
  ```json
  {
    "message": "Invalid credentials"
  }
  ```

---

## Headers
For all protected routes, include the JWT token in the Authorization header:
`Authorization: Bearer <your_token>`
